<?php

class cGallery extends cCustomGallery {};

class cTag {
	public $type;
	public $css;
	public $value;
	public $cid;
	function __construct ($type,$cid,$value){
		$this->type=$type;
		$this->cid=$cid;
		$this->value=$value;		
	}
	public function Value($value) {
		$this->value=$value;		
	}
	public function Show() {
		$t='';$cid='';
		$css=$this->css;
		if($this->cid!='') {
			$cid='data-id-type="'.$this->cid.'"';
			$css=$this->css.'-'.$this->cid;
		}		
		echo "<".$this->type." class=\"".$css."\" $cid>".$this->value."</".$this->type.">";
	}
}

class cCustomGallery {
  
  private $name="";  
  private $title="";  
  private $css = "GALLERY";  
  protected $uid = '';  
  private $buttons = array();  
  private $content = array();

	function __construct ($name,$title,$type,$content)  
	{
		//error_reporting(E_ALL);
		//ini_set('display_errors', TRUE);
		//ini_set('display_startup_errors', TRUE);			
		
		$this->name=str_replace(' ','',$name);
		$this->uid=strtoupper(uniqid($this->name,true));
		$this->title=$title;	
		$this->css=$type;				
		
		if(is_array	($content))	$this->content=$content;
		else $this->content=null;
		
		$this->onCreate();
	}  
	
	public function setViewType($newType)
	{
		$this->css=$newType;
	}
	
	protected function onCreate() {}	
	protected function onShow() {}		
		
	public function Show() {
		
		$this->onShow();
		
		$this->_build_list_contents();
		
		echo "<div id=\"FULL-LIST\" class=\"LISTBASE\">";	
		$this->_process($this->content);
		echo "</div>";	

	}
	
	
	private function _build_list_contents()
	{
		echo "<div id=\"TITLE-LIST\" class=\"TITLE-LIST\" >";	
		echo "<div class=\"TITLE-BANNER\" >".$this->title."</div>";	
			echo "<table class=\"TITLE-MODES\"><tr>";	
			echo "<td class=\"TITLE-MODES\" onclick=\"changeView('GALLERY')\" >Galery</td>";
			echo "<td class=\"TITLE-MODES\" onclick=\"changeView('COMPACT-VIEW')\" >Compact</td>";	
			echo "<td class=\"TITLE-MODES\" onclick=\"changeView('LIST-VIEW')\" >ListView</td>";		
		echo "</tr></table>";
		echo "</div>";	
	}
	
	
	protected $tags=array();	
	protected $dtags=array('div','h1','h2','h3','p','img');
	protected function isTAG($tag) {
		foreach($this->dtags as $v) {
			if($v==$tag)return true;
		}
		return false;
	}
	public function AddTAG($tag,$css) {	
		if(!$this->isTAG($tag))return;	
		$tmp=array("tag"=>$tag,"css"=>$css,"value"=>'');
		array_push($this->tags,$tmp);
	}
	private function insertTAG($tag,$value){
		$tag->Show();
	}	
	public function createTAG($tag,$css) {	
		if(!$this->isTAG($tag))return;	
		$tmp=new cTag($tag,$css,'');
		$tmp->css=$this->css;
		array_push($this->tags,$tmp);
		return $tmp;
	}	


	
	protected $vdata=array();
	protected function OnPrepare($fields,$value,&$data) {
		//$data['title']='title';
		//$this->vdata['title']='';
		//$data['body']='';
		//$data['data']=array();		
	}		
	protected function OnDone($fields,$value,&$data) {
	}



	private function _process($data) {		
		if(is_array($data)) {
			foreach ( $data as $f => $v ) {
				$data = array();
				$this->OnPrepare($f,$v,$data);
				$this->_build_item_contents($data);		
				$this->OnDone($f,$v,$data);									
			}				
		}
	}	
		
	private function _build_item_contents($d) 
	{
		$css=$this->css;				
		$id=$d['ident'];		
		$cid = strtoupper(uniqid($this->name,false));		
		echo "<div id=\"$cid\" class=\"$css\" onmouseenter=\"MouseEnter('$id')\" onmouseleave=\"MouseLeave('$id')\"   >";				
			echo "<div class=\"$css-CONTROLS\">";		
			
				//echo "<h1 class=\"$css\">".$d['title']."</h1>";				
				
				//echo "<p class=\"$css\"   >";
					//echo $cid." - ".$d['body'];
				//echo "</p>";			
				
				foreach($this->tags as $n => $v) {				
					$this->insertTAG($v,'vAl');
				}
				
				echo $this->_build_insert_details($css,$d['data']);
				
				if(count($this->buttons) > 0 ) {		
						
					echo "<table class=\"$css-TOOLBAR\" data-id-type=\"TOOLBAR\"><tr>";		
					foreach($this->buttons as $n => $i){
						echo "<td id=\"".$i['perfil']."\" class=\"$css-TOOLBAR\" data-id-type=\"TOOLBAR\" onclick=\"showViewer('".$i['cmd']."','$id')\"></td>";				
					}			
					echo "</tr></table>";						
				}				
			echo "</div>";						
		echo "</div>";			
	}
	
	private function _build_insert_details($css,$data) 
	{
		if(!$data)return "";
		$tmp = "<table class=\"$css-DETAILS\"  data-id-type=\"DETAILS\" >";			
		$healder="<tr class=\"$css-DETAILS\"  data-id-type=\"DETAILS\">";
		$rowData="<tr class=\"$css-DETAILS\"  data-id-type=\"DETAILS\">";		
		foreach($data as $n=>$i){
			$healder=$healder."<th class=\"$css-DETAILS\"  data-id-type=\"DETAILS\" >$n</th>";
			$rowData=$rowData."<td class=\"$css-DETAILS\"  data-id-type=\"DETAILS\" >$i</td>";		
		}	
		$tmp=$tmp.$healder."</tr>".$rowData."</tr></table>";
		return $tmp;
	}
	
	function create_sql($dt)
	{
	}
	
	public function addItem($item)
	{
		$tmp=array("item"=>$item,"ident"=>$ident);
		array_push($this->buttons,$tmp);						
	}
	
	public function addButton($name,$cmd,$ident)
	{
		$tmp=array("perfil"=>$name,"cmd"=>$cmd,"ident"=>$ident);
		array_push($this->buttons,$tmp);				
	}
	
	

};

?>
